import os 
import numpy as np 
import pandas as pd 


FEATURE = 'eval'
DIR ='results/'
exp_name_list = ['PExp--walker', 'PEM--walker', 'ER1--walker', 'ER3--walker', 'ER7--walker']


folder_name_list = []
for item in os.listdir(DIR):
    folder_name_list.append(item)

folder_name_list.sort()


def print_mean_std_for_last_10_evaluations(exp_name, step=10):
    data = []
    for folder_name in folder_name_list:
        if exp_name in folder_name:
            for item in pd.read_csv(DIR + folder_name)[FEATURE][:200][-step:]:
                data.append(item)
    data = np.array(data)
    print(exp_name, '\t', data.mean(), '\t', data.std())
    # For box plot,
    # for i in data:
    #     print(i, end=', ')
    # print('\n')

for exp_name in exp_name_list:
    print_mean_std_for_last_10_evaluations(exp_name)